/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.track_api;

import com.jozufozu.flywheel.core.PartialModel;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.custom_tracks.CustomTrackBlock;
import com.railwayteam.railways.content.custom_tracks.monorail.MonorailTrackBlock;
import com.railwayteam.railways.mixin.AccessorBlockEntityType;
import com.railwayteam.railways.multiloader.Env;
import com.railwayteam.railways.track_api.TrackMaterialFactory;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.trains.track.TrackBlock;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TrackMaterial {
    public static final List<TrackMaterial> ALL = new ArrayList<TrackMaterial>();
    public static final TrackMaterial ANDESITE = TrackMaterial.make(Create.asResource((String)"andesite")).lang("Andesite").block(() -> AllBlocks.TRACK).particle(Create.asResource((String)"block/palettes/stone_types/polished/andesite_cut_polished")).setBuiltin().build();
    public final ResourceLocation id;
    public final String langName;
    public final Supplier<BlockEntry<? extends TrackBlock>> trackBlock;
    public final Ingredient sleeperIngredient;
    public final Ingredient railsIngredient;
    public final ResourceLocation particle;
    public final TrackType trackType;
    @OnlyIn(value=Dist.CLIENT)
    protected TrackModelHolder modelHolder;

    @OnlyIn(value=Dist.CLIENT)
    public TrackModelHolder getModelHolder() {
        return this.modelHolder;
    }

    public static TrackMaterialFactory make(ResourceLocation id) {
        return new TrackMaterialFactory(id);
    }

    public TrackMaterial(ResourceLocation id, String langName, Supplier<BlockEntry<? extends TrackBlock>> trackBlock, ResourceLocation particle, Ingredient sleeperIngredient, Ingredient railsIngredient, TrackType trackType, Supplier<Supplier<TrackModelHolder>> modelHolder) {
        this.id = id;
        this.langName = langName;
        this.trackBlock = trackBlock;
        this.sleeperIngredient = sleeperIngredient;
        this.railsIngredient = railsIngredient;
        this.particle = particle;
        this.trackType = trackType;
        Env.CLIENT.runIfCurrent(() -> () -> this.lambda$new$1((Supplier)modelHolder));
        ALL.add(this);
    }

    public BlockEntry<? extends TrackBlock> getTrackBlock() {
        return this.trackBlock.get();
    }

    public CustomTrackBlock create(BlockBehaviour.Properties properties) {
        return this.trackType.create(properties, this);
    }

    public boolean isCustom(String modId) {
        return this.id.m_135827_().equals(modId);
    }

    public static TrackMaterial[] allCustom(String modid) {
        return (TrackMaterial[])ALL.stream().filter(tm -> tm.isCustom(modid)).toArray(TrackMaterial[]::new);
    }

    public static List<BlockEntry<?>> allCustomBlocks(String modid) {
        ArrayList list = new ArrayList();
        for (TrackMaterial material : TrackMaterial.allCustom(modid)) {
            list.add(material.getTrackBlock());
        }
        return list;
    }

    public static List<BlockEntry<?>> allBlocks() {
        ArrayList list = new ArrayList();
        for (TrackMaterial material : ALL) {
            list.add(material.getTrackBlock());
        }
        return list;
    }

    public static void addCustomValidTracks(BlockEntityType<?> type) {
        AccessorBlockEntityType access = (AccessorBlockEntityType)type;
        HashSet<Block> blocks = new HashSet<Block>(access.getValidBlocks());
        TrackMaterial.allBlocks().forEach(entry -> blocks.add((Block)entry.get()));
        access.setValidBlocks(blocks);
    }

    public String resName() {
        return this.id.m_135815_();
    }

    public static TrackMaterial deserialize(String serializedName) {
        if (!((String)serializedName).contains(":")) {
            String mod = ((String)serializedName).equals("andesite") ? "create" : "railways";
            String oldName = serializedName;
            serializedName = mod + ":" + (String)serializedName;
            Railways.LOGGER.warn("Legacy track material detected (no namespace): " + oldName + " -> " + (String)serializedName);
        }
        ResourceLocation id = new ResourceLocation((String)serializedName);
        for (TrackMaterial material : ALL) {
            if (!material.id.equals((Object)id)) continue;
            return material;
        }
        return ANDESITE;
    }

    private /* synthetic */ void lambda$new$1(Supplier modelHolder) {
        this.modelHolder = (TrackModelHolder)((Supplier)modelHolder.get()).get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class TrackModelHolder {
        static final TrackModelHolder DEFAULT = new TrackModelHolder(AllBlockPartials.TRACK_TIE, AllBlockPartials.TRACK_SEGMENT_LEFT, AllBlockPartials.TRACK_SEGMENT_RIGHT);
        public final PartialModel tie;
        public final PartialModel segment_left;
        public final PartialModel segment_right;

        protected TrackModelHolder(PartialModel tie, PartialModel segment_left, PartialModel segment_right) {
            this.tie = tie;
            this.segment_left = segment_left;
            this.segment_right = segment_right;
        }
    }

    public static class TrackType {
        public static final TrackType STANDARD = new TrackType(Create.asResource((String)"standard"), CustomTrackBlock::new);
        public static final TrackType MONORAIL = new TrackType(Railways.asResource("monorail"), MonorailTrackBlock::new);
        public final ResourceLocation id;
        private final CustomTrackBlockFactory factory;

        public TrackType(ResourceLocation id, CustomTrackBlockFactory factory) {
            this.id = id;
            this.factory = factory;
        }

        protected CustomTrackBlock create(BlockBehaviour.Properties properties, TrackMaterial material) {
            return this.factory.create(properties, material);
        }

        @FunctionalInterface
        private static interface CustomTrackBlockFactory {
            public CustomTrackBlock create(BlockBehaviour.Properties var1, TrackMaterial var2);
        }
    }
}

